using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;

using VirtualLab.Programming;
using VirtualLab.Design;
using VirtualLabAPI.Core.BasicFunctions;
using VirtualLabAPI.Core.Common;
using VirtualLabAPI.Core.DataVisualization;
using VirtualLabAPI.Core.FieldRepresentations;
using VirtualLabAPI.Core.Functions;
using VirtualLabAPI.Core.GeometryDescription;
using VirtualLabAPI.Core.LightPath;
using VirtualLabAPI.Core.Materials;
using VirtualLabAPI.Core.Modules;
using VirtualLabAPI.Core.Numerics;
using VirtualLabAPI.Core.Numerics.Region2D;
using VirtualLabAPI.Core.OpticalSystems;
using VirtualLabAPI.Core.Propagation;
using VirtualLabAPI.Core.SupportFunctions;

namespace OwnCode {
    public class VLModule : IVLModule {
        public void Run() {
            
            DataArray1D desiredPhaseProfile = (DataArray1D) VL_GUI.SelectOpenDataArray1D("Select Desired Phase Profile");
            DataArray1D diameterPhaseLookupTable = (DataArray1D) VL_GUI.SelectOpenDataArray1D("Select Diameter-Phase Lookup Table");
            
            // extract the actual data container in "ComplexField" format
            ComplexField phaseProfile = desiredPhaseProfile.Data[0];
            double samplingDistance = desiredPhaseProfile.SamplingDistance;
            // initialize container for pillar diameters
            double[,] diameterProfile = new double[2, phaseProfile.SamplingPoints.X];
            // define diameter values in a loop
            for (int i = 0; i < phaseProfile.SamplingPoints.X; i++)
            {
                // get current phase value
                double phaseValue = phaseProfile[i, 0].Re;
                // lift to [0, 2Pi]
                phaseValue += Math.PI;
                // find corresponding diameter
                long dummyOutLong;
                bool dummyOutBool;
                double diameterValue = diameterPhaseLookupTable.PointInterpolation(phaseValue,
                    true,
                    out dummyOutLong,
                    out dummyOutBool)[0].Re;
                // fill the value
                diameterProfile[0, i] = desiredPhaseProfile.CoordinateOfFirstDataPoint + i * samplingDistance;
                diameterProfile[1, i] = diameterValue;
            }
            // display
            DataArray2D diameterProfileDataArray = new DataArray2D(diameterProfile,
                PhysicalProperty.Length,
                "Pillar Position & Diameter",
                1.0,
                0.0,
                PhysicalProperty.NoUnit,
                "Position / Diameter",
                desiredPhaseProfile.SamplingDistance,
                desiredPhaseProfile.CoordinateOfFirstDataPoint,
                desiredPhaseProfile.PhysicalPropertyOfCoordinates,
                desiredPhaseProfile.CommentOfCoordinates);
            Globals.DataDisplay.ShowDocument(diameterProfileDataArray, "Pillar Position and Diameter");
            
        }
    }
}